<!DOCTYPE html>

<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
      data-assets-path="../../assets/" data-template="horizontal-menu-template-starter">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Simpham</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ url('assets/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />

    <link rel="stylesheet" href="{{ url('assets/vendor/fonts/boxicons.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/fonts/fontawesome.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/fonts/flag-icons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ url('assets/vendor/css/rtl/core.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/css/rtl/theme-default.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/css/demo.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/sweetalert2/sweetalert2.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/typeahead-js/typeahead.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/select2/select2.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/tagify/tagify.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/apex-charts/apex-charts.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.css') }}" />

    <link rel="stylesheet" href="{{ url('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/typeahead-js/typeahead.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/quill/typography.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/quill/katex.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/quill/editor.css') }}" />
    <link rel="stylesheet" href="{{ url('assets/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.css') }}" />

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/handsontable@13.0.0/dist/handsontable.min.css">

    <script src="{{ url('assets/vendor/js/helpers.js') }}"></script>
    {{--    <script src="{{ url('assets/vendor/js/template-customizer.js') }}"></script>--}}
    <script src="{{ url('assets/js/config.js') }}"></script>



    @stack('css')

</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-navbar-full layout-horizontal layout-without-menu">
    <div class="layout-container">
        <!-- Navbar -->

        <nav class="layout-navbar navbar navbar-expand-xl align-items-center bg-navbar-theme" id="layout-navbar">
            <div class="container-fluid">
                <div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4">
                    <a href="{{ route('dashboard') }}" class="app-brand-link gap-2">
                        <img
                            src="{{ url('assets/img/logo_new.png') }}"
                            alt="Auth Cover Bg color"
                            width="200"
                             />
                    </a>
                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-xl-none">
                        <i class="bx bx-x bx-sm align-middle"></i>
                    </a>
                </div>

                <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                    <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                        <i class="bx bx-menu bx-sm"></i>
                    </a>
                </div>

                <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                    <div class="navbar-nav align-items-center">
                        <div class="nav-item dropdown-style-switcher dropdown me-2 me-xl-0">
                            <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);"
                               data-bs-toggle="dropdown">
                                <i class="bx bx-sm"></i>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-start dropdown-styles">
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0);" data-theme="light">
                                        <span class="align-middle"><i class="bx bx-sun me-2"></i>Light</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0);" data-theme="dark">
                                        <span class="align-middle"><i class="bx bx-moon me-2"></i>Dark</span>
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="javascript:void(0);" data-theme="system">
                                        <span class="align-middle"><i class="bx bx-desktop me-2"></i>System</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <ul class="navbar-nav flex-row align-items-center ms-auto">
                        <!-- User -->
                        <li class="nav-item navbar-dropdown dropdown-user dropdown">
                            <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);"
                               data-bs-toggle="dropdown">
                                <div class="avatar avatar-online">
                                    <img src="{{ url('assets/img/avatars/1.png') }}" alt
                                         class="rounded-circle" />
                                </div>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item" href="#">
                                        <div class="d-flex">
                                            <div class="flex-shrink-0 me-3">
                                                <div class="avatar avatar-online">
                                                    <img src="{{ url('assets/img/avatars/1.png') }}" alt
                                                         class="rounded-circle" />
                                                </div>
                                            </div>
                                            <div class="flex-grow-1">
                                                <span class="fw-medium d-block lh-1">John Doe</span>
                                                <small>Admin</small>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                                <li>
                                    <div class="dropdown-divider"></div>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('logout') }}">
                                        <i class="bx bx-power-off me-2"></i>
                                        <span class="align-middle">Log Out</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <!--/ User -->
                    </ul>
                </div>
            </div>
        </nav>

        <!-- / Navbar -->

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Menu -->
                @if(auth()->user()->role == 'administrator')
                    <aside id="layout-menu"
                           class="layout-menu-horizontal menu-horizontal menu bg-menu-theme flex-grow-0">
                        <div class="container-fluid d-flex h-100">
                            <ul class="menu-inner">
                                <!-- Dashboards -->
                                <li class="menu-item">
                                    <a href="{{ route('dashboard') }}" class="menu-link">
                                        <i class="menu-icon tf-icons bx bx-home-circle"></i>
                                        <div data-i18n="Page 1">Dashboard {{ auth()->user()->role }}</div>
                                    </a>
                                </li>
                                <li class="menu-item">
                                    <a href="javascript:void(0)" class="menu-link menu-toggle">
                                        <i class="menu-icon tf-icons bx bx-layout"></i>
                                        <div data-i18n="Layouts">Master Data</div>
                                    </a>
                                    <ul class="menu-sub">
                                        <li class="menu-item">
                                            <a href="{{ route('users') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-user"></i>
                                                <div data-i18n="Without menu">User</div>
                                            </a>
                                        </li>
                                        <li class="menu-item">
                                            <a href="{{ route('jenis.rekomendasi') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-album"></i>
                                                <div data-i18n="Without menu">Jenis Rekomendasi</div>
                                            </a>
                                        </li>
                                        <li class="menu-item">
                                            <a href="{{ route('pelaksana') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-building-house"></i>
                                                <div data-i18n="Without menu">Pelaksana Rekomendasi</div>
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                                <li class="menu-item">
                                    <a href="{{ route('korbans') }}" class="menu-link">
                                        <i class="menu-icon tf-icons bx bx-user-circle"></i>
                                        <div data-i18n="Page 1">Data Korban</div>
                                    </a>
                                </li>
                                <li class="menu-item">
                                    <a href="javascript:void(0)" class="menu-link menu-toggle">
                                        <i class="menu-icon tf-icons bx bx-transfer"></i>
                                        <div data-i18n="Layouts">Monitoring</div>
                                    </a>
                                    <ul class="menu-sub">
                                        <li class="menu-item">
                                            <a href="{{ route('aduans') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-data"></i>
                                                <div data-i18n="Page 1">Monitoring Pelanggaran HAM</div>
                                            </a>
                                        </li>
                                        <li class="menu-item">
                                            <a href="{{ route('aduans') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-check-shield"></i>
                                                <div data-i18n="Page 1">Tindaklanjuti Rekomendasi</div>
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                                <li class="menu-item">
                                    <a href="javascript:void(0)" class="menu-link menu-toggle">
                                        <i class="menu-icon tf-icons bx bx-receipt"></i>
                                        <div data-i18n="Layouts">Laporan</div>
                                    </a>
                                    <ul class="menu-sub">
                                        <li class="menu-item">
                                            <a href="{{ route('aduans') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-data"></i>
                                                <div data-i18n="Page 1">Laporan Penyelesain</div>
                                            </a>
                                        </li>
                                        <li class="menu-item">
                                            <a href="{{ route('aduans') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-check-shield"></i>
                                                <div data-i18n="Page 1">Laporan Hasil</div>
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </aside>
                @else
                    <aside id="layout-menu"
                           class="layout-menu-horizontal menu-horizontal menu bg-menu-theme flex-grow-0">
                        <div class="container-fluid d-flex h-100">
                            <ul class="menu-inner">
                                <!-- Dashboards -->
                                <li class="menu-item">
                                    <a href="{{ route('dashboard') }}" class="menu-link">
                                        <i class="menu-icon tf-icons bx bx-home-circle"></i>
                                        <div data-i18n="Page 1">Dashboard</div>
                                    </a>
                                </li>

                                <li class="menu-item">
                                    <a href="{{ route('korbans') }}" class="menu-link">
                                        <i class="menu-icon tf-icons bx bx-user-circle"></i>
                                        <div data-i18n="Page 1">Data Korban</div>
                                    </a>
                                </li>
                                <li class="menu-item">
                                    <a href="{{ route('aduans') }}" class="menu-link">
                                        <i class="menu-icon tf-icons bx bx-check-shield"></i>
                                        <div data-i18n="Page 1">Tindaklanjuti</div>
                                    </a>
                                </li>

                                <li class="menu-item">
                                    <a href="javascript:void(0)" class="menu-link menu-toggle">
                                        <i class="menu-icon tf-icons bx bx-receipt"></i>
                                        <div data-i18n="Layouts">Laporan</div>
                                    </a>
                                    <ul class="menu-sub">
                                        <li class="menu-item">
                                            <a href="{{ route('aduans') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-data"></i>
                                                <div data-i18n="Page 1">Laporan Penyelesain</div>
                                            </a>
                                        </li>
                                        <li class="menu-item">
                                            <a href="{{ route('aduans') }}" class="menu-link">
                                                <i class="menu-icon tf-icons bx bx-check-shield"></i>
                                                <div data-i18n="Page 1">Laporan Hasil</div>
                                            </a>
                                        </li>

                                    </ul>
                                </li>

                            </ul>
                        </div>
                    </aside>
                @endif

                <!-- / Menu -->
                <div class="container-fluid flex-grow-1 container-p-y">
                    @yield('body')
                </div>
                <!--/ Content -->
                <footer class="content-footer footer bg-footer-theme">
                    <div
                        class="container-fluid d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                        <div class="mb-2 mb-md-0">
                            ©
                            <script>
                                document.write(new Date().getFullYear());
                            </script>
                            , made with ❤️ by
                            <a href="https://pixinvent.com" target="_blank"
                               class="footer-link fw-medium">Pixinvent</a>
                        </div>
                        <div class="d-none d-lg-inline-block">
                            <a href="https://demos.pixinvent.com/frest-html-admin-template/documentation/"
                               target="_blank" class="footer-link me-4">Documentation</a>
                        </div>
                    </div>
                </footer>
                <!-- / Footer -->

                <div class="content-backdrop fade"></div>
            </div>
            <!--/ Content wrapper -->
        </div>

        <!--/ Layout container -->
    </div>
</div>

<!-- Overlay -->
<div class="layout-overlay layout-menu-toggle"></div>

<!-- Drag Target Area To SlideIn Menu On Small Screens -->
<div class="drag-target"></div>

<!--/ Layout wrapper -->

<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->

<script src="{{ url('assets/vendor/libs/jquery/jquery.js') }}"></script>
<script src="{{ url('assets/vendor/libs/popper/popper.js') }}"></script>
<script src="{{ url('assets/vendor/js/bootstrap.js') }}"></script>
<script src="{{ url('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
<script src="{{ url('assets/vendor/libs/hammer/hammer.js') }}"></script>
<script src="{{ url('assets/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>


<script src="{{ url('assets/vendor/js/menu.js') }}"></script>

<script src="{{ url('assets/js/main.js') }}"></script>

<!-- Handsontable JS -->
<script src="https://cdn.jsdelivr.net/npm/handsontable@13.0.0/dist/handsontable.min.js"></script>

<script src="{{ url('assets/js/forms-selects.js') }}"></script>

<script src="{{ url('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>

<script src="{{ url('assets/vendor/libs/select2/select2.js') }}"></script>

<script src="{{ url('assets/vendor/libs/moment/moment.js') }}"></script>

<script src="{{ url('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>

<script src="{{ url('assets/vendor/libs/chartjs/chartjs.js') }}"></script>

<script src="{{ url('assets/vendor/libs/tagify/tagify.js') }}"></script>

<script src="{{ url('assets/vendor/libs/apex-charts/apexcharts.js') }}"></script>

<script src="{{ url('assets/vendor/libs/quill/katex.js') }}"></script>

<script src="{{ url('assets/vendor/libs/quill/quill.js') }}"></script>

<script src="{{ url('assets/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js') }}"></script>

<script>

    $(function() {
        @if (\Illuminate\Support\Facades\Session::has('message'))
        Swal.fire({
            icon: '{{ \Illuminate\Support\Facades\Session::get('icon') }}',
            text: '{{ \Illuminate\Support\Facades\Session::get('message') }}',
            button: false,
            timer: 1500
        });
        @endif
    });
    select2 = $('.select2');
    select2Icons = $('.select2-icons');
    $(".yearpicker").datepicker( {
        format: "yyyy",
        viewMode: "year",
    });
    $('.show-alert-delete-box').click(function(event) {
        event.preventDefault(); // cegah form submit default

        const form = $(this).closest("form")[0]; // ambil form DOM, bukan jQuery object

        Swal.fire({
            title: 'You sure?',
            text: "Data will be delete forever!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Ya, hapus!',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit(); // hanya jika user benar2 menekan "Ya, hapus"
            }
        });
    });
</script>

@stack('scripts')
</body>

</html>
