@extends('layouts.layout')
@section('body')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Data Pelaksana</h5>
            <div class="d-flex align-items-center gap-2">
                <form method="GET" action="{{ route('pelaksana') }}" class="d-flex gap-2">
                    <input type="text" name="name" value="{{ request('name') }}" class="form-control"
                        placeholder="Search by name">
                    <button type="submit" class="btn btn-secondary">
                        <i class="bx bx-search"></i>
                    </button>
                </form>
                <a href="{{ route('pelaksana.create') }}" class="btn btn-primary">
                    <i class="bx bx-plus me-1"></i> Tambah
                </a>
            </div>
        </div>
        <div class="table-responsive text-nowrap">
            <table class="table">
                <thead>
                    <tr>

                        <th>Nama</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                    @foreach ($data as $item)
                        <tr>
                            <td>{{ $item->nama }}</td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('pelaksana.edit', $item->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i>
                                            Edit</a>
                                        <form action="{{ route('pelaksana.delete', $item->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="dropdown-item show-alert-delete-box"><i
                                                    class="bx bx-trash me-1"></i>
                                                Delete</button>
                                        </form>

                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-between align-items-center mt-3 px-3">
            <div class="text-muted small">
                Showing {{ $data->firstItem() }} to {{ $data->lastItem() }} of {{ $data->total() }} users
            </div>
            <div>
                {{ $data->links() }}
            </div>
        </div>
    </div>
@endsection
