@extends('layouts.layout')
@section('body')
    <div class="card mb-4">
        <h5 class="card-header">Create User</h5>
        <form class="card-body" action="{{ route('users.store') }}" method="POST">
            @csrf

            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label" for="multicol-username">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="john.doe"
                        value="{{ old('name') }}">
                    @if ($errors->has('name'))
                        <span class="text-danger">{{ $errors->first('name') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Email</label>
                    <input type="email" class="form-control" name="email" aria-label="john.doe"
                        value="{{ old('email') }}">
                    @if ($errors->has('name'))
                        <span class="text-danger">{{ $errors->first('name') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-password">Password</label>
                        <input type="password" id="multicol-password" class="form-control" placeholder="············"
                            name="password">
                        @if ($errors->has('password'))
                            <span class="text-danger">{{ $errors->first('password') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Confirm Password</label>
                        <input type="password" class="form-control" name="password_confirmation" placeholder="············">
                        @if ($errors->has('password'))
                            <span class="text-danger">{{ $errors->first('password') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Roles</label>
                        <select name="role" class="form-select">
                            <option value="administrator" {{ old('role') == 'admin' ? 'selected' : '' }}>Admin</option>
                            <option value="komnas_ham" {{ old('role') == 'komnas_ham' ? 'selected' : '' }}>Komnas HAM</option>
                            <option value="kemenkumham" {{ old('role') == 'kemenkumham' ? 'selected' : '' }}>Kemenkumhan</option>
                            <option value="kementrian" {{ old('role') == 'kementrian' ? 'selected' : '' }}>Kementrian/Lembaga</option>
                        </select>
                        @if ($errors->has('role'))
                            <span class="text-danger">{{ $errors->first('role') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Lembaga</label>
                        <select name="pelaksana_id" class="form-select select2">
                            @foreach($pelaksana as $p)
                                <option value="{{ $p->id }}" {{ request('pelaksana_id') == $p->id ? 'selected' : '' }}>{{ $p->nama }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('role'))
                            <span class="text-danger">{{ $errors->first('role') }}</span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="pt-4">
                <button type="submit" class="btn btn-primary me-sm-3 me-1">Simpan</button>
                <a href="{{ route('users') }}" class="btn btn-label-secondary">Kembali</a>
            </div>
        </form>
    </div>
@endsection
