@extends('layouts.layout')
@section('body')
    <div class="card mb-4">
        <h5 class="card-header">Create User</h5>
        <form class="card-body" action="{{ route('users.update', $data->id) }}" method="POST">
            @csrf
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label" for="multicol-username">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="john.doe"
                        value="{{ $data->name }}">
                    @if ($errors->has('name'))
                        <span class="text-danger">{{ $errors->first('name') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Email</label>
                    <input type="email" class="form-control" name="email" aria-label="john.doe"
                        value="{{ $data->email }}">
                    @if ($errors->has('name'))
                        <span class="text-danger">{{ $errors->first('name') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-password">Password</label>
                        <input type="password" id="multicol-password" class="form-control" placeholder="············"
                            name="password">
                        @if ($errors->has('password'))
                            <span class="text-danger">{{ $errors->first('password') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Confirm Password</label>
                        <input type="password" class="form-control" name="password_confirmation" placeholder="············">
                        @if ($errors->has('password'))
                            <span class="text-danger">{{ $errors->first('password') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Roles</label>
                        <select name="role" class="form-select">
                            <option value="administrator" {{ $data->role == 'admin' ? 'selected' : '' }}>Admin</option>
                            <option value="komnas_ham" {{ $data->role == 'komnas_ham' ? 'selected' : '' }}>Komnas HAM</option>
                            <option value="kemenkumham" {{ $data->role == 'kemenkumham' ? 'selected' : '' }}>Kemenkumhan</option>
                            <option value="kementrian" {{ $data->role == 'kementrian' ? 'selected' : '' }}>Kementrian/Lembaga</option>
                        </select>
                        @if ($errors->has('roles'))
                            <span class="text-danger">{{ $errors->first('roles') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Lembaga</label>
                        <select name="pelaksana_id" class="form-select select2">
                            @foreach($pelaksana as $p)
                                <option value="{{ $p->id }}" {{ request('role') == 'admin' ? 'selected' : '' }}>{{ $p->nama }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('role'))
                            <span class="text-danger">{{ $errors->first('role') }}</span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="pt-4">
                <button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
                <a href="{{ route('users') }}" class="btn btn-label-secondary">Cancel</a>
            </div>
        </form>
    </div>
@endsection
