@extends('layouts.layout')
@section('body')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">User List</h5>
            <div class="d-flex align-items-center gap-2">
                {{-- Form Filter --}}
                <form method="GET" action="{{ route('users') }}" class="d-flex gap-2">
                    {{-- Filter Role --}}
                    <select name="role" class="form-select">
                        <option value="">All Roles</option>
                        <option value="administrator" {{ request('role') == 'superadmin' ? 'selected' : '' }}>Administrator</option>
                        <option value="komnas_ham" {{ request('role') == 'komnas_ham' ? 'selected' : '' }}>Komnas HAM</option>
                        <option value="kemenkumham" {{ request('role') == 'kemenkumham' ? 'selected' : '' }}>Kemenkumhan</option>
                        <option value="kementrian" {{ request('role') == 'kementrian' ? 'selected' : '' }}>Kementrian/Lembaga</option>
                    </select>
                    <input type="text" name="name" value="{{ request('name') }}" class="form-control"
                        placeholder="Search by name">
                    <button type="submit" class="btn btn-secondary">
                        <i class="bx bx-search"></i>
                    </button>
                </form>

                {{-- Tombol Create --}}
                <a href="{{ route('users.create') }}" class="btn btn-primary">
                    <i class="bx bx-plus me-1"></i> Tambah Data
                </a>
            </div>
        </div>
        <div class="table-responsive text-nowrap">
            <table class="table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Pelaksana/Lembaga</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                    @foreach ($data as $item)
                        <tr>
                            <td>{{ $item->name }}</td>
                            <td>{{ $item->email }}</td>
                            <td>{{ ucwords(str_replace('_', ' ', $item->role)) }}</td>
                            <td>{{ $item->pelaksana->nama ?? "Tidak memiliki Lembaga" }}</td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('users.edit', $item->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i>
                                            Edit</a>
                                        <form action="{{ route('users.delete', $item->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="dropdown-item show-alert-delete-box"><i
                                                    class="bx bx-trash me-1"></i>
                                                Delete</button>
                                        </form>

                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-between align-items-center mt-3 px-3">
            <div class="text-muted small">
                Showing {{ $data->firstItem() }} to {{ $data->lastItem() }} of {{ $data->total() }} users
            </div>
            <div>
                {{ $data->links() }}
            </div>
        </div>
    </div>
@endsection
