<?php

use Illuminate\Support\Facades\Route;

Route::get('login', [App\Http\Controllers\AuthController::class, 'login'])->name('login');
Route::post('login', [App\Http\Controllers\AuthController::class, 'doLogin'])->name('do.login');
Route::get('logout', [App\Http\Controllers\AuthController::class, 'logout'])->name('logout');

Route::get('/', [App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard')->middleware(['auth']);

Route::group(['prefix' => 'users', 'middleware' => ['auth']], function () {
    Route::get('/', [App\Http\Controllers\UsersController::class, 'index'])->name('users');
    Route::get('/create', [App\Http\Controllers\UsersController::class, 'create'])->name('users.create');
    Route::post('/store', [App\Http\Controllers\UsersController::class, 'store'])->name('users.store');
    Route::get('/edit/{id}', [App\Http\Controllers\UsersController::class, 'edit'])->name('users.edit');
    Route::post('/update/{id}', [App\Http\Controllers\UsersController::class, 'update'])->name('users.update');
    Route::delete('/delete/{id}', [App\Http\Controllers\UsersController::class, 'delete'])->name('users.delete');
});

Route::group(['prefix' => 'korbans', 'middleware' => ['auth']], function () {
    Route::get('/', [App\Http\Controllers\KorbanController::class, 'index'])->name('korbans');
    Route::get('/create', [App\Http\Controllers\KorbanController::class, 'create'])->name('korbans.create');
    Route::post('/store', [App\Http\Controllers\KorbanController::class, 'store'])->name('korbans.store');
    Route::get('/edit/{id}', [App\Http\Controllers\KorbanController::class, 'edit'])->name('korbans.edit');
    Route::post('/update/{id}', [App\Http\Controllers\KorbanController::class, 'update'])->name('korbans.update');
    Route::delete('/delete/{id}', [App\Http\Controllers\KorbanController::class, 'delete'])->name('korbans.delete');
});

Route::group(['prefix' => 'aduans', 'middleware' => ['auth']], function () {
    Route::get('/', [App\Http\Controllers\AduanController::class, 'index'])->name('aduans');
    Route::get('/create', [App\Http\Controllers\AduanController::class, 'create'])->name('aduans.create');
    Route::post('/store', [App\Http\Controllers\AduanController::class, 'store'])->name('aduans.store');
    Route::get('/edit/{id}', [App\Http\Controllers\AduanController::class, 'edit'])->name('aduans.edit');
    Route::post('/update/{id}', [App\Http\Controllers\AduanController::class, 'update'])->name('aduans.update');
    Route::delete('/delete/{id}', [App\Http\Controllers\AduanController::class, 'delete'])->name('aduans.delete');
});

Route::group(['prefix' => 'jenis.rekomendasi', 'middleware' => ['auth']], function () {
    Route::get('/', [App\Http\Controllers\JenisRekomendasiController::class, 'index'])->name('jenis.rekomendasi');
    Route::get('/create', [App\Http\Controllers\JenisRekomendasiController::class, 'create'])->name('jenis.rekomendasi.create');
    Route::post('/store', [App\Http\Controllers\JenisRekomendasiController::class, 'store'])->name('jenis.rekomendasi.store');
    Route::get('/edit/{id}', [App\Http\Controllers\JenisRekomendasiController::class, 'edit'])->name('jenis.rekomendasi.edit');
    Route::post('/update/{id}', [App\Http\Controllers\JenisRekomendasiController::class, 'update'])->name('jenis.rekomendasi.update');
    Route::delete('/delete/{id}', [App\Http\Controllers\JenisRekomendasiController::class, 'delete'])->name('jenis.rekomendasi.delete');
});

Route::group(['prefix' => 'pelaksana', 'middleware' => ['auth']], function () {
    Route::get('/', [App\Http\Controllers\PelaksanaController::class, 'index'])->name('pelaksana');
    Route::get('/create', [App\Http\Controllers\PelaksanaController::class, 'create'])->name('pelaksana.create');
    Route::post('/store', [App\Http\Controllers\PelaksanaController::class, 'store'])->name('pelaksana.store');
    Route::get('/edit/{id}', [App\Http\Controllers\PelaksanaController::class, 'edit'])->name('pelaksana.edit');
    Route::post('/update/{id}', [App\Http\Controllers\PelaksanaController::class, 'update'])->name('pelaksana.update');
    Route::delete('/delete/{id}', [App\Http\Controllers\PelaksanaController::class, 'delete'])->name('pelaksana.delete');
});

Route::group(['prefix' => 'tindak-lanjut', 'middleware' => ['auth']], function () {
    Route::get('/', [App\Http\Controllers\TindakLanjutController::class, 'index'])->name('tindaklanjut');
    Route::get('/create', [App\Http\Controllers\TindakLanjutController::class, 'create'])->name('tindaklanjut.create');
    Route::post('/store', [App\Http\Controllers\TindakLanjutController::class, 'store'])->name('tindaklanjut.store');
    Route::get('/edit/{id}', [App\Http\Controllers\TindakLanjutController::class, 'edit'])->name('tindaklanjut.edit');
    Route::post('/update/{id}', [App\Http\Controllers\TindakLanjutController::class, 'update'])->name('tindaklanjut.update');
    Route::delete('/delete/{id}', [App\Http\Controllers\TindakLanjutController::class, 'delete'])->name('tindaklanjut.delete');
});
