
<?php $__env->startSection('body'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Data Pelanggaran HAM</h5>
            <div class="d-flex align-items-center gap-2">
                <form method="GET" action="<?php echo e(route('aduans')); ?>" class="d-flex gap-2">
                    <input type="text" name="name" value="<?php echo e(request('name')); ?>" class="form-control"
                        placeholder="Search by name">
                    <button type="submit" class="btn btn-secondary">
                        <i class="bx bx-search"></i>
                    </button>
                </form>
                <a href="<?php echo e(route('aduans.create')); ?>" class="btn btn-primary">
                    <i class="bx bx-plus me-1"></i> Tambah
                </a>
            </div>
        </div>
        <div class="table-responsive text-nowrap">
            <table class="table">
                <thead>
                    <tr>
                        <th>No Pelanggaran</th>
                        <th>ID Korban</th>
                        <th>Nama Lengkap</th>
                        <th>Tempat Lahir</th>
                        <th>Tanggal Lahir</th>
                        <th>Jenis Kelamin</th>
                        <th>Lokasi Kejadian</th>
                        <th>Jenis Pelanggaran</th>
                        <th>Kasus Pelanggaran</th>
                        <th>Tahun Keputusan</th>
                        <th>Rekomendasi Pemulihan</th>
                        <th>Status Korban</th>
                        <th>Lembaga Penanggung Jawab</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->nomor); ?></td>
                            <td><?php echo e($item->korban->kode_korban); ?></td>
                            <td><?php echo e($item->korban->nama); ?></td>
                            <td><?php echo e($item->korban->tempat_lahir); ?></td>
                            <td><?php echo e($item->korban->tanggal_lahir); ?></td>
                            <td><?php echo e($item->korban->jenis_kelamin); ?></td>
                            <td><?php echo e($item->lokasi); ?></td>
                            <td><?php echo e(ucfirst(str_replace('_','',$item->jenis))); ?></td>
                            <td><?php echo e($item->korban->kasus_pelanggaran ?? ""); ?></td>
                            <td><?php echo e($item->korban->tahun_keputusan ?? ""); ?></td>
                            <td><?php echo e($item->jenis_rekomendasi->nama); ?></td>
                            <td><?php echo e(ucfirst(str_replace('_',' ',$item->korban->status_korban))); ?></td>
                            <td><?php echo e($item->pelaksana->nama ?? "Lembaga belum ditentukan"); ?></td>

                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('aduans.edit', $item->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i>
                                            Edit</a>
                                        <form action="<?php echo e(route('aduans.delete', $item->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="dropdown-item show-alert-delete-box"><i
                                                    class="bx bx-trash me-1"></i>
                                                Delete</button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-between align-items-center mt-3 px-3">
            <div class="text-muted small">
                Showing <?php echo e($data->firstItem()); ?> to <?php echo e($data->lastItem()); ?> of <?php echo e($data->total()); ?> users
            </div>
            <div>
                <?php echo e($data->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/aduan/index.blade.php ENDPATH**/ ?>