<?php $__env->startSection('body'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">User List</h5>
            <div class="d-flex align-items-center gap-2">
                
                <form method="GET" action="<?php echo e(route('users')); ?>" class="d-flex gap-2">
                    
                    <select name="role" class="form-select">
                        <option value="">All Roles</option>
                        <option value="administrator" <?php echo e(request('role') == 'superadmin' ? 'selected' : ''); ?>>Administrator</option>
                        <option value="komnas_ham" <?php echo e(request('role') == 'komnas_ham' ? 'selected' : ''); ?>>Komnas HAM</option>
                        <option value="kemenkumham" <?php echo e(request('role') == 'kemenkumham' ? 'selected' : ''); ?>>Kemenkumhan</option>
                        <option value="kementrian" <?php echo e(request('role') == 'kementrian' ? 'selected' : ''); ?>>Kementrian/Lembaga</option>
                    </select>
                    <input type="text" name="name" value="<?php echo e(request('name')); ?>" class="form-control"
                        placeholder="Search by name">
                    <button type="submit" class="btn btn-secondary">
                        <i class="bx bx-search"></i>
                    </button>
                </form>

                
                <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary">
                    <i class="bx bx-plus me-1"></i> Tambah Data
                </a>
            </div>
        </div>
        <div class="table-responsive text-nowrap">
            <table class="table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Pelaksana/Lembaga</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->name); ?></td>
                            <td><?php echo e($item->email); ?></td>
                            <td><?php echo e(ucwords(str_replace('_', ' ', $item->role))); ?></td>
                            <td><?php echo e($item->pelaksana->nama ?? "Tidak memiliki Lembaga"); ?></td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('users.edit', $item->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i>
                                            Edit</a>
                                        <form action="<?php echo e(route('users.delete', $item->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="dropdown-item show-alert-delete-box"><i
                                                    class="bx bx-trash me-1"></i>
                                                Delete</button>
                                        </form>

                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-between align-items-center mt-3 px-3">
            <div class="text-muted small">
                Showing <?php echo e($data->firstItem()); ?> to <?php echo e($data->lastItem()); ?> of <?php echo e($data->total()); ?> users
            </div>
            <div>
                <?php echo e($data->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/user/index.blade.php ENDPATH**/ ?>