<?php $__env->startSection('body'); ?>
    <div class="card mb-4">
        <h5 class="card-header">Create User</h5>
        <form class="card-body" action="<?php echo e(route('users.update', $data->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label" for="multicol-username">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="john.doe"
                        value="<?php echo e($data->name); ?>">
                    <?php if($errors->has('name')): ?>
                        <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Email</label>
                    <input type="email" class="form-control" name="email" aria-label="john.doe"
                        value="<?php echo e($data->email); ?>">
                    <?php if($errors->has('name')): ?>
                        <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-password">Password</label>
                        <input type="password" id="multicol-password" class="form-control" placeholder="············"
                            name="password">
                        <?php if($errors->has('password')): ?>
                            <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Confirm Password</label>
                        <input type="password" class="form-control" name="password_confirmation" placeholder="············">
                        <?php if($errors->has('password')): ?>
                            <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Roles</label>
                        <select class="form-control" name="roles">
                            <option <?php if($data->roles == 'admin'): ?> selected <?php endif; ?> value="admin">Admin</option>
                            <option <?php if($data->roles == 'manager'): ?> selected <?php endif; ?> value="manager">Manager</option>
                            <option <?php if($data->roles == 'os_people'): ?> selected <?php endif; ?> value="os_people">Os People
                            </option>
                            <option <?php if($data->roles == 'os_manager'): ?> selected <?php endif; ?> value="os_manager">Os Manager
                            </option>
                        </select>
                        <?php if($errors->has('roles')): ?>
                            <span class="text-danger"><?php echo e($errors->first('roles')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="pt-4">
                <button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
                <a href="<?php echo e(route('users')); ?>" class="btn btn-label-secondary">Cancel</a>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/user/edit.blade.php ENDPATH**/ ?>