<?php $__env->startSection('body'); ?>
    <div class="card mb-4">
        <h5 class="card-header">Create User</h5>
        <form class="card-body" action="<?php echo e(route('users.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label" for="multicol-username">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="john.doe"
                        value="<?php echo e(old('name')); ?>">
                    <?php if($errors->has('name')): ?>
                        <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Email</label>
                    <input type="email" class="form-control" name="email" aria-label="john.doe"
                        value="<?php echo e(old('email')); ?>">
                    <?php if($errors->has('name')): ?>
                        <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-password">Password</label>
                        <input type="password" id="multicol-password" class="form-control" placeholder="············"
                            name="password">
                        <?php if($errors->has('password')): ?>
                            <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Confirm Password</label>
                        <input type="password" class="form-control" name="password_confirmation" placeholder="············">
                        <?php if($errors->has('password')): ?>
                            <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Roles</label>
                        <select name="role" class="form-select">
                            <option value="administrator" <?php echo e(request('role') == 'admin' ? 'selected' : ''); ?>>Admin</option>
                            <option value="komnas_ham" <?php echo e(request('role') == 'komnas_ham' ? 'selected' : ''); ?>>Komnas HAM</option>
                            <option value="kemenkumham" <?php echo e(request('role') == 'kemenkumham' ? 'selected' : ''); ?>>Kemenkumhan</option>
                            <option value="kementrian" <?php echo e(request('role') == 'kementrian' ? 'selected' : ''); ?>>Kementrian/Lembaga</option>
                        </select>
                        <?php if($errors->has('role')): ?>
                            <span class="text-danger"><?php echo e($errors->first('role')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="pt-4">
                <button type="submit" class="btn btn-primary me-sm-3 me-1">Simpan</button>
                <a href="<?php echo e(route('users')); ?>" class="btn btn-label-secondary">Kembali</a>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\simpham2\resources\views/user/create.blade.php ENDPATH**/ ?>