<table class="table table-striped">
    <thead>
        <tr>
            <th>Date</th>
            <th>Rooms Occupied</th>
            <th>Total Rooms</th>
            <th>Occupancy Rate</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $occupancies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $occupancy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td><?php echo e($occupancy->date->format('Y-m')); ?></td>
            <td><?php echo e($occupancy->rooms_occupied); ?></td>
            <td><?php echo e($occupancy->total_rooms); ?></td>
            <td><?php echo e(number_format($occupancy->occupancy_rate, 2)); ?>%</td>
            <td>
                <a href="<?php echo e(route('hotel-occupancy.edit', $occupancy->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                <form action="<?php echo e(route('hotel-occupancy.destroy', $occupancy->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                </form>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td colspan="5" class="text-center">No data available</td>
        </tr>
        <?php endif; ?>
    </tbody>
</table><?php /**PATH G:\Repositories_Zyuuxyncool\skiripsi\resources\views/hotel-occupancy/_table.blade.php ENDPATH**/ ?>